#include <stdint.h>

#define true 1

void example ( void )
{
  uint16_t u16a;
  int8_t   s8a;

/* ----------------- Example code from MISRA C:2012 begin ----------------- */

  s8a = ( u16a < 0u ) ? 0 : 1;         /* Non-compliant */

  if ( u16a < 0xffffu )                /* Non-compliant */
  {
  }

  if ( 2 > 3 )                         /* Non-compliant */
  {
  }

  for ( s8a = 0; s8a < 130; ++s8a )    /* Non-compliant */
  {
  }

  if ( ( s8a < 10 ) && ( s8a > 20 ) )  /* Non-compliant */
  {
  }

  if ( ( s8a < 10 ) || ( s8a > 5 ) )   /* Non-compliant */
  {
  }

  while ( s8a > 10 )
  {
    if ( s8a > 5 )                     /* Non-compliant */
    {
    }
  }

  while ( true )                       /* Compliant     */
  {
  }

  do
  {
  } while ( 0u == 1u );                /* Compliant     */

  const uint8_t numcyl = 4u;

  if ( numcyl == 4u )                  /* Non-compliant */
  {
  }

  const volatile uint8_t numcyl_cal = 4u;

  if ( numcyl_cal == 4u )              /* Compliant     */
  {
  }

  uint16_t n;
  uint16_t sum;

  sum = 0;

  for ( uint16_t i = ( n - 6u ); i < n; ++i )
  {
    sum += i;
  }

  if ( ( sum % 2u ) == 0u )            /* Non-compliant */
  {
  }
  
/* ------------------ Example code from MISRA C:2012 end ------------------ */
}
